#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

using DBCONSTANTS = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using BLOODUNIT = gov.va.med.vbecs.Common.VbecsTables.BloodUnit;
using ORDEREDUNIT = gov.va.med.vbecs.Common.VbecsTables.OrderedUnit;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;


#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmReleaseUnits
	/// </summary>
	public class FrmReleaseUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private static string _singleUnitExpiredBase = "Blood Unit number ";
		private static string _multipleUnitsExpiredBase = "Blood Unit numbers: ";
		private static string _comma = ", ";

		private ArrayList _orderedUnits;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.TextBox txtPatient;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.GroupBox grpAssignedUnits;
		private System.Windows.Forms.ListView lvAssignedUnits;
		private System.Windows.Forms.GroupBox grpSearch;
		private gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtUnitID;
		private System.Windows.Forms.Label lblPatient;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.GroupBox grpUnitExpires;
		private System.Windows.Forms.DateTimePicker dtpUnitExpiresBefore;
		private System.Windows.Forms.CheckBox cbUnitExpiresBefore;
		private System.Windows.Forms.CheckBox cbUnitExpiresAfter;
		private System.Windows.Forms.DateTimePicker dtpUnitExpiresAfter;
		private System.Windows.Forms.GroupBox grpSpecimenExpires;
		private System.Windows.Forms.DateTimePicker dtpSpecimenExpiresBefore;
		private System.Windows.Forms.CheckBox cbSpecimenExpiresBefore;
		private System.Windows.Forms.CheckBox cbSpecimenExpiresAfter;
		private System.Windows.Forms.DateTimePicker dtpSpecimenExpiresAfter;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.Panel pnlReleaseUnits;
		private System.Windows.Forms.Button btnUncheckAll;
		private System.Windows.Forms.Button btnCheckAll;
		private Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmReleaseUnits));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlReleaseUnits = new System.Windows.Forms.Panel();
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.grpSpecimenExpires = new System.Windows.Forms.GroupBox();
			this.dtpSpecimenExpiresBefore = new System.Windows.Forms.DateTimePicker();
			this.cbSpecimenExpiresBefore = new System.Windows.Forms.CheckBox();
			this.cbSpecimenExpiresAfter = new System.Windows.Forms.CheckBox();
			this.dtpSpecimenExpiresAfter = new System.Windows.Forms.DateTimePicker();
			this.grpUnitExpires = new System.Windows.Forms.GroupBox();
			this.dtpUnitExpiresBefore = new System.Windows.Forms.DateTimePicker();
			this.cbUnitExpiresBefore = new System.Windows.Forms.CheckBox();
			this.cbUnitExpiresAfter = new System.Windows.Forms.CheckBox();
			this.dtpUnitExpiresAfter = new System.Windows.Forms.DateTimePicker();
			this.btnClear = new System.Windows.Forms.Button();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtPatient = new System.Windows.Forms.TextBox();
			this.txtUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
			this.pictureBox4 = new System.Windows.Forms.PictureBox();
			this.lblPatient = new System.Windows.Forms.Label();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.grpAssignedUnits = new System.Windows.Forms.GroupBox();
			this.btnCheckAll = new System.Windows.Forms.Button();
			this.lvAssignedUnits = new System.Windows.Forms.ListView();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.btnUncheckAll = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.pnlReleaseUnits.SuspendLayout();
			this.grpSearch.SuspendLayout();
			this.grpSpecimenExpires.SuspendLayout();
			this.grpUnitExpires.SuspendLayout();
			this.grpAssignedUnits.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(736, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Release Unit(s) from Patient Assignment";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 473);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(578, 464);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(658, 464);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlReleaseUnits
			// 
			this.pnlReleaseUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlReleaseUnits.Controls.Add(this.grpSearch);
			this.pnlReleaseUnits.Controls.Add(this.grpAssignedUnits);
			this.pnlReleaseUnits.Controls.Add(this.groupBox2);
			this.pnlReleaseUnits.Location = new System.Drawing.Point(0, 32);
			this.pnlReleaseUnits.Name = "pnlReleaseUnits";
			this.pnlReleaseUnits.Size = new System.Drawing.Size(736, 428);
			this.pnlReleaseUnits.TabIndex = 0;
			// 
			// grpSearch
			// 
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.grpSpecimenExpires);
			this.grpSearch.Controls.Add(this.grpUnitExpires);
			this.grpSearch.Controls.Add(this.btnClear);
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Controls.Add(this.txtPatient);
			this.grpSearch.Controls.Add(this.txtUnitID);
			this.grpSearch.Controls.Add(this.pictureBox4);
			this.grpSearch.Controls.Add(this.lblPatient);
			this.grpSearch.Controls.Add(this.lblUnitID);
			this.grpSearch.Location = new System.Drawing.Point(60, 4);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(672, 84);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Assigned Units Search Criteria";
			// 
			// grpSpecimenExpires
			// 
			this.grpSpecimenExpires.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSpecimenExpires.Controls.Add(this.dtpSpecimenExpiresBefore);
			this.grpSpecimenExpires.Controls.Add(this.cbSpecimenExpiresBefore);
			this.grpSpecimenExpires.Controls.Add(this.cbSpecimenExpiresAfter);
			this.grpSpecimenExpires.Controls.Add(this.dtpSpecimenExpiresAfter);
			this.grpSpecimenExpires.Location = new System.Drawing.Point(408, 10);
			this.grpSpecimenExpires.Name = "grpSpecimenExpires";
			this.grpSpecimenExpires.Size = new System.Drawing.Size(172, 68);
			this.grpSpecimenExpires.TabIndex = 5;
			this.grpSpecimenExpires.TabStop = false;
			this.grpSpecimenExpires.Text = "Specimen Expires";
			// 
			// dtpSpecimenExpiresBefore
			// 
			this.dtpSpecimenExpiresBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpSpecimenExpiresBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpSpecimenExpiresBefore.Location = new System.Drawing.Point(60, 16);
			this.dtpSpecimenExpiresBefore.Name = "dtpSpecimenExpiresBefore";
			this.dtpSpecimenExpiresBefore.Size = new System.Drawing.Size(108, 20);
			this.dtpSpecimenExpiresBefore.TabIndex = 1;
			this.dtpSpecimenExpiresBefore.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
			// 
			// cbSpecimenExpiresBefore
			// 
			this.cbSpecimenExpiresBefore.Location = new System.Drawing.Point(4, 16);
			this.cbSpecimenExpiresBefore.Name = "cbSpecimenExpiresBefore";
			this.cbSpecimenExpiresBefore.Size = new System.Drawing.Size(60, 20);
			this.cbSpecimenExpiresBefore.TabIndex = 0;
			this.cbSpecimenExpiresBefore.Text = "B&efore";
			// 
			// cbSpecimenExpiresAfter
			// 
			this.cbSpecimenExpiresAfter.Location = new System.Drawing.Point(4, 40);
			this.cbSpecimenExpiresAfter.Name = "cbSpecimenExpiresAfter";
			this.cbSpecimenExpiresAfter.Size = new System.Drawing.Size(52, 20);
			this.cbSpecimenExpiresAfter.TabIndex = 2;
			this.cbSpecimenExpiresAfter.Text = "A&fter";
			// 
			// dtpSpecimenExpiresAfter
			// 
			this.dtpSpecimenExpiresAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpSpecimenExpiresAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpSpecimenExpiresAfter.Location = new System.Drawing.Point(60, 40);
			this.dtpSpecimenExpiresAfter.Name = "dtpSpecimenExpiresAfter";
			this.dtpSpecimenExpiresAfter.Size = new System.Drawing.Size(108, 20);
			this.dtpSpecimenExpiresAfter.TabIndex = 3;
			this.dtpSpecimenExpiresAfter.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
			// 
			// grpUnitExpires
			// 
			this.grpUnitExpires.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnitExpires.Controls.Add(this.dtpUnitExpiresBefore);
			this.grpUnitExpires.Controls.Add(this.cbUnitExpiresBefore);
			this.grpUnitExpires.Controls.Add(this.cbUnitExpiresAfter);
			this.grpUnitExpires.Controls.Add(this.dtpUnitExpiresAfter);
			this.grpUnitExpires.Location = new System.Drawing.Point(224, 10);
			this.grpUnitExpires.Name = "grpUnitExpires";
			this.grpUnitExpires.Size = new System.Drawing.Size(172, 68);
			this.grpUnitExpires.TabIndex = 4;
			this.grpUnitExpires.TabStop = false;
			this.grpUnitExpires.Text = "Unit Expires";
			// 
			// dtpUnitExpiresBefore
			// 
			this.dtpUnitExpiresBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpUnitExpiresBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpUnitExpiresBefore.Location = new System.Drawing.Point(60, 16);
			this.dtpUnitExpiresBefore.Name = "dtpUnitExpiresBefore";
			this.dtpUnitExpiresBefore.Size = new System.Drawing.Size(108, 20);
			this.dtpUnitExpiresBefore.TabIndex = 1;
			this.dtpUnitExpiresBefore.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
			// 
			// cbUnitExpiresBefore
			// 
			this.cbUnitExpiresBefore.Location = new System.Drawing.Point(4, 16);
			this.cbUnitExpiresBefore.Name = "cbUnitExpiresBefore";
			this.cbUnitExpiresBefore.Size = new System.Drawing.Size(60, 20);
			this.cbUnitExpiresBefore.TabIndex = 0;
			this.cbUnitExpiresBefore.Text = "&Before";
			// 
			// cbUnitExpiresAfter
			// 
			this.cbUnitExpiresAfter.Location = new System.Drawing.Point(4, 40);
			this.cbUnitExpiresAfter.Name = "cbUnitExpiresAfter";
			this.cbUnitExpiresAfter.Size = new System.Drawing.Size(52, 20);
			this.cbUnitExpiresAfter.TabIndex = 2;
			this.cbUnitExpiresAfter.Text = "&After";
			// 
			// dtpUnitExpiresAfter
			// 
			this.dtpUnitExpiresAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpUnitExpiresAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpUnitExpiresAfter.Location = new System.Drawing.Point(60, 40);
			this.dtpUnitExpiresAfter.Name = "dtpUnitExpiresAfter";
			this.dtpUnitExpiresAfter.Size = new System.Drawing.Size(108, 20);
			this.dtpUnitExpiresAfter.TabIndex = 3;
			this.dtpUnitExpiresAfter.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(592, 24);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 6;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(592, 52);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 7;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtPatient
			// 
			this.txtPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatient.Location = new System.Drawing.Point(76, 48);
			this.txtPatient.MaxLength = 20;
			this.txtPatient.Name = "txtPatient";
			this.txtPatient.Size = new System.Drawing.Size(136, 20);
			this.txtPatient.TabIndex = 3;
			this.txtPatient.Text = "";
			// 
			// txtUnitID
			// 
			this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitID.Barcode = false;
			this.txtUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtUnitID.Location = new System.Drawing.Point(76, 20);
			this.txtUnitID.MaxLength = 15;
			this.txtUnitID.Name = "txtUnitID";
			this.txtUnitID.Size = new System.Drawing.Size(136, 20);
			this.txtUnitID.TabIndex = 1;
			this.txtUnitID.Text = "";
			// 
			// pictureBox4
			// 
			this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
			this.pictureBox4.Location = new System.Drawing.Point(10, 24);
			this.pictureBox4.Name = "pictureBox4";
			this.pictureBox4.Size = new System.Drawing.Size(20, 20);
			this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox4.TabIndex = 56;
			this.pictureBox4.TabStop = false;
			// 
			// lblPatient
			// 
			this.lblPatient.Location = new System.Drawing.Point(32, 48);
			this.lblPatient.Name = "lblPatient";
			this.lblPatient.Size = new System.Drawing.Size(40, 20);
			this.lblPatient.TabIndex = 2;
			this.lblPatient.Text = "Patient";
			this.lblPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitID
			// 
			this.lblUnitID.Location = new System.Drawing.Point(32, 20);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(40, 20);
			this.lblUnitID.TabIndex = 0;
			this.lblUnitID.Text = "Unit ID";
			this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpAssignedUnits
			// 
			this.grpAssignedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAssignedUnits.Controls.Add(this.btnCheckAll);
			this.grpAssignedUnits.Controls.Add(this.lvAssignedUnits);
			this.grpAssignedUnits.Controls.Add(this.btnUncheckAll);
			this.grpAssignedUnits.Location = new System.Drawing.Point(60, 92);
			this.grpAssignedUnits.Name = "grpAssignedUnits";
			this.grpAssignedUnits.Size = new System.Drawing.Size(672, 332);
			this.grpAssignedUnits.TabIndex = 1;
			this.grpAssignedUnits.TabStop = false;
			this.grpAssignedUnits.Text = "Select Assigned Units for Release";
			// 
			// btnCheckAll
			// 
			this.btnCheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnCheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnCheckAll.Image")));
			this.btnCheckAll.Location = new System.Drawing.Point(640, 0);
			this.btnCheckAll.Name = "btnCheckAll";
			this.btnCheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnCheckAll.TabIndex = 15;
			this.btnCheckAll.Click += new System.EventHandler(this.btnCheckAll_Click);
			// 
			// lvAssignedUnits
			// 
			this.lvAssignedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAssignedUnits.CheckBoxes = true;
			this.lvAssignedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader6,
																							  this.columnHeader7,
																							  this.columnHeader8,
																							  this.columnHeader9,
																							  this.columnHeader10,
																							  this.columnHeader11,
																							  this.columnHeader12,
																							  this.columnHeader13,
																							  this.columnHeader15,
																							  this.columnHeader14});
			this.lvAssignedUnits.FullRowSelect = true;
			this.lvAssignedUnits.Location = new System.Drawing.Point(8, 16);
			this.lvAssignedUnits.MultiSelect = false;
			this.lvAssignedUnits.Name = "lvAssignedUnits";
			this.lvAssignedUnits.Size = new System.Drawing.Size(656, 308);
			this.lvAssignedUnits.TabIndex = 0;
			this.lvAssignedUnits.View = System.Windows.Forms.View.Details;
			this.lvAssignedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvAssignedUnits_ColumnClick);
			this.lvAssignedUnits.SelectedIndexChanged += new System.EventHandler(this.lvAssignedUnits_SelectedIndexChanged);
			this.lvAssignedUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvAssignedUnits_ItemCheck);
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "";
			this.columnHeader6.Width = 25;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Patient Name";
			this.columnHeader7.Width = 80;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Patient ID";
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Unit ID";
			this.columnHeader9.Width = 50;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Product";
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Product Name";
			this.columnHeader11.Width = 80;
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "ABO/Rh";
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "Unit Expires";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Donation";
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "Specimen Expires";
			this.columnHeader14.Width = 100;
			// 
			// btnUncheckAll
			// 
			this.btnUncheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUncheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnUncheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnUncheckAll.Image")));
			this.btnUncheckAll.Location = new System.Drawing.Point(624, 0);
			this.btnUncheckAll.Name = "btnUncheckAll";
			this.btnUncheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnUncheckAll.TabIndex = 14;
			this.btnUncheckAll.Click += new System.EventHandler(this.btnUncheckAll_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox2.Controls.Add(this.pictureBox2);
			this.groupBox2.Location = new System.Drawing.Point(4, 4);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(52, 420);
			this.groupBox2.TabIndex = 2;
			this.groupBox2.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(45, 45);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 0;
			this.pictureBox2.TabStop = false;
			// 
			// FrmReleaseUnits
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(736, 489);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.pnlReleaseUnits);
			this.hlphelpChm.SetHelpKeyword(this, "Release_Units_From_Patient_Assignment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(628, 516);
			this.Name = "FrmReleaseUnits";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Release Unit(s) from Patient Assignment";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmReleaseUnits_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlReleaseUnits, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlReleaseUnits.ResumeLayout(false);
			this.grpSearch.ResumeLayout(false);
			this.grpSpecimenExpires.ResumeLayout(false);
			this.grpUnitExpires.ResumeLayout(false);
			this.grpAssignedUnits.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmReleaseUnits()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC047ReleaseUnitFromPatientAssignment;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
			//
			this.RetrieveOrderedUnits();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// btnOK_Click Event Handler
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			ArrayList checkedItems = new ArrayList(this.lvAssignedUnits.Items.Count);
			ArrayList expiredUnits = new ArrayList();

			StringBuilder message = new StringBuilder(); 

			for (int idx = 0; idx < this.lvAssignedUnits.Items.Count; idx++)
			{
				if(this.lvAssignedUnits.Items[idx].Checked)
				{
					checkedItems.Add(this.lvAssignedUnits.Items[idx].Tag);
				}
			}
			
			DlgConfirmRelease confirm = new DlgConfirmRelease();

            confirm.ShowDialogFromLockedParent(this, false);
			if (confirm.DialogResult == DialogResult.Yes)
			{
				
				DataTable dtBCEMessages = null;
				DataTable dtTempBCEMessages = null;

				//CR 2941
				//CR 2945
				//generate table with BCE_MESSAGE
				//The Unit is removed from assignment

				Guid bloodUnitGuid = Guid.Empty;
				Guid patientGuid = Guid.Empty;
				for (int i = 0; i < checkedItems.Count; i++)
				{
					Hashtable record = (Hashtable)checkedItems[i];
					//
					bloodUnitGuid = new Guid( (string)record[VbecsTables.BloodUnit.BloodUnitGuid] );
					patientGuid = BOL.OrderedUnit.GetPatientForOrderedUnit(new Guid( (string)record[VbecsTables.OrderedUnit.OrderedUnitGuid] ));
						
					//CR 3015
					if (dtBCEMessages == null)
					{
						dtBCEMessages = OrderedUnit.UpdateBceForRelease(bloodUnitGuid, patientGuid, false);
					}
					else
					{
						dtTempBCEMessages = OrderedUnit.UpdateBceForRelease(bloodUnitGuid, patientGuid, false);
						if (dtTempBCEMessages.Rows.Count > 0)
							dtBCEMessages.Rows.Add(dtTempBCEMessages.Rows[0].ItemArray);
					}
				}
				//BCE_MESSAGE end
				
				if (OrderedUnit.ReleaseOrderedUnits(checkedItems, confirm.ReleaseDate, confirm.TechId, confirm.Comment, ref 

					expiredUnits, this._workloadProcessId, dtBCEMessages))
				{
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					if (expiredUnits.Count > 0)
					{
						if (expiredUnits.Count == 1)
						{
							message.Append(_singleUnitExpiredBase);
							message.Append(expiredUnits[0]);
							message.Append(Common.StrRes.InfoMsg.UC047.SingleUnitExpired().ResString);
						}
						else
						{
							message.Append(_multipleUnitsExpiredBase);
							for (int i = 0; i < expiredUnits.Count - 1; i++)
							{
								message.Append(expiredUnits[i]);
								message.Append(_comma);
							}
							message.Append(expiredUnits[expiredUnits.Count - 1]);
							message.Append(Common.StrRes.InfoMsg.UC047.MultipleUnitsExpired().ResString);
						}
		
						DialogResult dlgResult = GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(message.ToString()));
						if (dlgResult != DialogResult.OK)
						{
							return;
						}
					}
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Restriction removal"));
					return;
				}
				this.UnlockAllRecords();
				//
				this.RetrieveOrderedUnits();
			}
		}

		/// <summary>
		/// btnCancel_Click Event Handler
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// btnClear_Click Event Handler
		/// </summary>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			SetComponentProperties();

			// Reload assigned units list
			LoadItemList(this._orderedUnits);
		}

		/// <summary>
		/// btnSearch_Click Event Handler
		/// </summary>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.SetCheckState(false);
			//
			FilterItemList();
		}

		/// <summary>
		/// lvAssignedUnits_ColumnClick Event Handler
		/// </summary>
		private void lvAssignedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			//re-sort the items.
			if ((e.Column == 7)||(e.Column == 9))
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvAssignedUnits.CheckBoxes, 

					controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvAssignedUnits.CheckBoxes, 

					controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		/// <summary>
		///
		/// </summary>
		private void lvAssignedUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			try
			{
                //CR1939 - Resorting the grid will mess up the _units variable, use the Tag 
                Hashtable tmpObjects = (Hashtable)this.lvAssignedUnits.Items[e.Index].Tag;
                string ouGuid = tmpObjects[ORDEREDUNIT.OrderedUnitGuid].ToString();
                this.LockController.RecordGuids.Add(new Guid(ouGuid));				
                //
				if (e.NewValue == CheckState.Checked)
				{
					// If they checked the box, attempt to lock it, if unsuccesful, uncheck the box and return
					if (!this.SetLocks())
					{
						e.NewValue = CheckState.Unchecked;
						return;
					}
				}
				else
				{
					// They've unchecked the box, so unlock the objects
					this.ReleaseLocks();
				}
				//
				if (e.CurrentValue.Equals(CheckState.Unchecked) ||
					this.lvAssignedUnits.CheckedItems.Count > 1)
				{
					btnOK.EnabledButton = true;
					this.btnOK.SetToolTip(string.Empty);
				}
				else
				{
					btnOK.EnabledButton = false;
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC047.SelectUnit().ResString);
				}
			}
			finally
			{
				Hashtable itemMap = (Hashtable)this.lvAssignedUnits.Items[e.Index].Tag;
				itemMap["checked"] = e.NewValue == CheckState.Checked;
				this.lvAssignedUnits.Items[e.Index].Tag = itemMap;
			}
		}

		/// <summary>
		/// btnUncheckAll_Click Event Handler
		/// </summary>
		private void btnUncheckAll_Click(object sender, System.EventArgs e)
		{
			this.SetCheckState(false);
		}

		/// <summary>
		/// btnCheckAll_Click Event Handler
		/// </summary>
		private void btnCheckAll_Click(object sender, System.EventArgs e)
		{
			this.SetCheckState(true);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmReleaseUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			this.SpeakMessage( this.btnOK.GetToolTip() );
		}

		#endregion
	
		#region Methods

		#region Initialize

		/// <summary>
		/// Initialize user control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC047.FrmReleaseUnits());
			//
			// Set custom date and time format
			this.dtpUnitExpiresBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpUnitExpiresAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpSpecimenExpiresBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpSpecimenExpiresAfter.CustomFormat = Common.VBECSDateTime.DateFormat;

			// Set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpUnitExpiresBefore.Value = _currentDate;
			this.dtpUnitExpiresAfter.Value = _currentDate;
			this.dtpSpecimenExpiresBefore.Value = _currentDate;
			this.dtpSpecimenExpiresAfter.Value = _currentDate;

			// Clear text boxes
			this.txtPatient.Text = "";
			this.txtUnitID.Text = "";

			// Clear check boxes
			this.cbSpecimenExpiresAfter.Checked = false;
			this.cbSpecimenExpiresBefore.Checked = false;
			this.cbUnitExpiresAfter.Checked = false;
			this.cbUnitExpiresBefore.Checked = false;

			this.cbSpecimenExpiresAfter.CheckState = CheckState.Unchecked;
			this.cbSpecimenExpiresBefore.CheckState = CheckState.Unchecked;
			this.cbUnitExpiresAfter.CheckState = CheckState.Unchecked;
			this.cbUnitExpiresBefore.CheckState = CheckState.Unchecked;

			//
			this.btnSearch.Text = "&Search";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
		}

		/// <summary>
		/// Load ordered units list
		/// </summary>
		private void RetrieveOrderedUnits()
		{
			this._orderedUnits = OrderedUnit.GetAssignedUnits();
			//
			this.LoadItemList(this._orderedUnits);
			//
			int count = this._orderedUnits.Count;
			//
			this.btnOK.EnabledButton = false;
			this.btnUncheckAll.Enabled = count > 0;
			this.btnCheckAll.Enabled = count > 0;
			//
			this.btnOK.SetToolTip( count > 0 ? Common.StrRes.Tooltips.UC047.SelectUnit().ResString : string.Empty );
		}

		/// <summary>
		/// Loads list view with data
		/// Implements BR_47.04
		/// </summary>
		/// <param name="items">data for list view</param>
		private void LoadItemList(ArrayList items)
		{
			try
			{
				this.lvAssignedUnits.Items.Clear();
				//
				for (int idx = 0; idx < items.Count; idx++)
				{
					Hashtable row = (Hashtable)items[idx];
					//
					// Keep track of checked flag
					bool itemChecked = false;
					if( !row.ContainsKey("checked") )
					{
						row.Add("checked", false);
					}
					else
					{
						itemChecked = Convert.ToBoolean( row["checked"] );
					}
					//
					ListViewItem lVI = new ListViewItem();	
					//
					// Patient Name
					string firstName = (string)row[TABLES.Patient.PatientFirstName];
					string middleName = (string)row[TABLES.Patient.PatientMiddleName];
					string lastName = (string)row[TABLES.Patient.PatientLastName];
					lVI.SubItems.Add(Patient.BuildDisplayName(firstName, middleName, lastName));
					// Patient ID
					lVI.SubItems.Add((string)row[TABLES.Patient.DisplayVistaPatientId]);
					// Unit ID
					lVI.SubItems.Add((string)row[TABLES.BloodUnit.EyeReadableUnitId]);
					// Product
					lVI.SubItems.Add((string)row[DBCONSTANTS.FullProductCode]);
					// Product Name
					lVI.SubItems.Add((string)row[TABLES.BloodProduct.ProductShortName]);
					// Abo/Rh
					lVI.SubItems.Add((string)row[DBCONSTANTS.ABORh]);
					// Unit Expires
					lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString((string)row[TABLES.BloodUnitMedia.UnitExpirationDate]));
					// Donation
					if( Utility.IsRestricted( Convert.ToInt32( (string)row[TABLES.DonationType.DonationTypeId] ) ) )
					{
						lVI.SubItems.Add((string)row[TABLES.DonationType.DonationTypeText]);
					}
					else
					{
						lVI.SubItems.Add(string.Empty);
					}
					// Specimen Expires
					lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString((string)row[TABLES.PatientSpecimen.SpecimenExpirationDate]));
					//
					lVI.Tag = row;
					this.lvAssignedUnits.Items.Add(lVI);
					//
					this.lvAssignedUnits.Items[idx].Checked = itemChecked;
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvAssignedUnits);
			}
			catch (Exception ex)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
			}
		}

		/// <summary>
		/// SetCheckState
		/// </summary>
		private void SetCheckState(bool isChecked)
		{
			int itemCount = this.lvAssignedUnits.Items.Count;
			//
			if(itemCount > 0)
			{
				for (int idx = 0; idx < itemCount; idx++)
				{
					this.lvAssignedUnits.Items[idx].Checked = isChecked;
					Hashtable itemMap = (Hashtable)this.lvAssignedUnits.Items[idx].Tag;
					itemMap["checked"] = isChecked;
					this.lvAssignedUnits.Items[idx].Tag = itemMap;
				}
			}
		}

		#endregion

		#region Filter\Search Functions

		/// <summary>
		/// Returns integer representation of date;
		/// we ignore the time of day
		/// </summary>
		private static int GetIntDate(DateTime date)
		{
			return (date.Year * 10000 + date.Month * 100 + date.Day);
		}

		/// <summary>
		/// Filters list view according to what items
		/// are chosen and the corresponding values
		/// </summary>
		private void FilterItemList()
		{
			this.lvAssignedUnits.Items.Clear();

			ArrayList filteredItems = new ArrayList();

			bool filterPatient = (txtPatient.Text != null && txtPatient.Text.Length > 0);
			bool filterUnitId = (txtUnitID.Text != null && txtUnitID.Text.Length > 0);

			// Filter records based on whether Patient Name, Unit Expires Before Date, etc.
			// are checked/filled in.  Note: if the user does not select any filter criteria
			// the filter will bring back all the same data as if the user did a non-filtered
			// search.  If they did enter something, a message will inform the user if no
			// records matched the search criteria.
			for (int i = 0; i < this._orderedUnits.Count; i++)
			{
				Hashtable record = (Hashtable)this._orderedUnits[i];
				//
				string unitExpirationDateStr = (string)record[TABLES.BloodUnitMedia.UnitExpirationDate];
				string specimenExpirationDateStr = (string)record[TABLES.PatientSpecimen.SpecimenExpirationDate];
				//
				DateTime unitExpirationDate = !(unitExpirationDateStr).Equals(string.Empty) ? System.DateTime.Parse(unitExpirationDateStr) : DateTime.MinValue;
				DateTime specimenExpirationDate = !(specimenExpirationDateStr).Equals(string.Empty) ? System.DateTime.Parse(specimenExpirationDateStr) : DateTime.MinValue;
				//
				int unitExpirationDateCheck = !unitExpirationDate.Equals(DateTime.MinValue) ? GetIntDate(unitExpirationDate): 0;
				int specimenExpirationDateCheck = !specimenExpirationDate.Equals(DateTime.MinValue) ? GetIntDate(specimenExpirationDate): 0;
				//
				bool unitExpDtBeforeOk = (cbUnitExpiresBefore.Checked 
					&& unitExpirationDateCheck > 0
					&& unitExpirationDateCheck < GetIntDate(dtpUnitExpiresBefore.Value))
					|| !cbUnitExpiresBefore.Checked
					|| unitExpirationDateCheck == 0;
				//
				bool unitExpDtAfterOk = (cbUnitExpiresAfter.Checked 
					&& unitExpirationDateCheck > 0
					&& unitExpirationDateCheck > GetIntDate(dtpUnitExpiresAfter.Value))
					|| !cbUnitExpiresAfter.Checked
					|| unitExpirationDateCheck == 0;
				//
				bool specExpDtBeforeOk = (cbSpecimenExpiresBefore.Checked 
					&& specimenExpirationDateCheck > 0
					&& specimenExpirationDateCheck < GetIntDate(dtpSpecimenExpiresBefore.Value))
					|| !cbSpecimenExpiresBefore.Checked
					|| specimenExpirationDateCheck == 0;
				//
				bool specExpDtAfterOk = (cbSpecimenExpiresAfter.Checked 
					&& specimenExpirationDateCheck > 0
					&& specimenExpirationDateCheck > GetIntDate(dtpSpecimenExpiresAfter.Value))
					|| !cbSpecimenExpiresAfter.Checked
					|| specimenExpirationDateCheck == 0;
				//
				bool patientOk = ((filterPatient 
					&& PatientMatch((string)record[TABLES.Patient.PatientLastName], (string)record[TABLES.Patient.DisplayVistaPatientId]))
					|| !filterPatient);
				//
				bool unitIdOk = ((filterUnitId 
					&& ((string)record[TABLES.BloodUnit.EyeReadableUnitId]).Equals(this.txtUnitID.Text)) 
					|| !filterUnitId);
				//
				if (unitExpDtBeforeOk && unitExpDtAfterOk && specExpDtBeforeOk && specExpDtAfterOk && patientOk && unitIdOk)
				{
					filteredItems.Add(record);
				}
			}

			if (filteredItems.Count > 0)
			{
				LoadItemList(filteredItems);
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC047.BloodUnitNotFound());
				//
				SetComponentProperties();

				// Reload assigned units list
				LoadItemList(this._orderedUnits);
			}
		}

		/// <summary>
		/// bool PatientMatch(string patientName, string patientID)
		/// Determines whether Patient info text box matches passed 
		/// in values using:
		/// Patient's Last Name
		/// Patient's ID
		/// Patient's last initial and last four digits of the Patient ID
		/// Last four digits of Patient ID
		/// Implements BR_3.20
		/// </summary>
		private bool PatientMatch(string patientName, string patientID)
		{
			bool result = false;
			string parsedId = "";
			foreach (char c in patientID.ToCharArray())
			{
				if(!c.Equals('-'))
				{
					parsedId = string.Concat(parsedId, c);
				}
			}
			
			// Patient ID searches
			if (Common.RegularExpressions.PatientSsn().IsMatch(txtPatient.Text))
			{
				

				// Full ssn (minus the minuses, of course)
				if (txtPatient.Text.Length == 9 && parsedId.Equals(txtPatient.Text))
				{
					result = true;
				}
				// Last 4 of ssn
				else if (txtPatient.Text.Length == 4 && parsedId.Substring(5, 4).Equals(txtPatient.Text))
				{
					result = true;
				}
			}

			// Last initial and last 4 ssn
			if (Common.RegularExpressions.PatientInitialAndLastFourSSN().IsMatch(txtPatient.Text))
			{
				StringBuilder initialAndId = new StringBuilder();

				initialAndId.Append(patientName.Substring(0, 1));
				initialAndId.Append(parsedId.Substring(5, 4));

				if (initialAndId.ToString().ToUpper().Equals(txtPatient.Text.ToUpper()))
				{
					result = true;
				}

			}

			// First initial search
			else if (txtPatient.Text.Length == 1)
			{
				if (patientName.ToUpper().Substring(0, 1).Equals(txtPatient.Text.Substring(0, 1).ToUpper()))
				{
					result = true;
				}
			}
				// Last name search
			else 
			{
				char [] chars = patientName.ToCharArray();
				StringBuilder lastName = new StringBuilder();

				// Parse patient name string
				for (int i = 0; i < chars.Length; i++)
				{
					if (chars[i] != ',')
					{
						lastName.Append(chars[i]);
					}	
					else
					{
						break;
					}
				}

				if (lastName.ToString().ToUpper().Equals(txtPatient.Text.ToUpper()))
				{
					result = true;
				}
			}

			return result;
		}

		#endregion

		private void lvAssignedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvAssignedUnits);
		}

		#endregion
	} 
}

